/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.api.engine;

import frc.emul.api.engine.IDebugEngine;
import frc.emul.api.engine.IEngineBreakpoint;
import frc.emul.mc6809.Instruction;

public class DebugEvent {
    private final IEngineBreakpoint bkpt;
    private final IDebugEngine engine;
    private final Kind kind;
    private final Reason cause;

    public DebugEvent(IDebugEngine iDebugEngine, Kind kind, Reason reason, IEngineBreakpoint iEngineBreakpoint) {
        assert (iDebugEngine != null);
        assert (kind != null);
        assert (reason != null);
        this.engine = iDebugEngine;
        this.kind = kind;
        this.cause = reason;
        this.bkpt = iEngineBreakpoint;
    }

    public IEngineBreakpoint getBreakpoint() {
        return this.bkpt;
    }

    public IDebugEngine getEngine() {
        return this.engine;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Reason getReason() {
        return this.cause;
    }

    public boolean isStepStart() {
        switch (this.getReason()) {
            case STEP_INTO: 
            case STEP_OVER: 
            case STEP_RETURN: 
            case STEP_RUNTO: {
                return true;
            }
        }
        return false;
    }

    public Instruction getCurrentInstruction() {
        return this.getEngine().getCore().getCPU().getCurrentInstruction();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append((Object)this.getKind()).append('(').append((Object)this.getReason()).append(')');
        if (this.getReason() == Reason.BREAKPOINT) {
            stringBuffer.append(" : ").append(this.getBreakpoint().getHitString());
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        CREATE(Reason.UNSPECIFIED, Reason.CLIENT_REQUEST),
        RESUME(Reason.CLIENT_REQUEST, Reason.STEP_INTO, Reason.STEP_OVER, Reason.STEP_RETURN, Reason.STEP_RUNTO),
        SUSPEND(Reason.CLIENT_REQUEST, Reason.STEP_END, Reason.ENGINE_ERROR, Reason.BREAKPOINT),
        TERMINATE(Reason.CLIENT_REQUEST, Reason.ENGINE_ERROR);

        private final boolean[] valid;
        private final Reason[] causes;

        private Kind(Reason ... reasonArray) {
            this.causes = reasonArray;
            this.valid = new boolean[Reason.values().length];
            Reason[] reasonArray2 = reasonArray;
            int n2 = reasonArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Reason reason = reasonArray2[n3];
                this.valid[reason.ordinal()] = true;
                ++n3;
            }
        }

        public final boolean accepts(Reason reason) {
            return this.valid[reason.ordinal()];
        }

        public final Reason[] getCauses() {
            return this.causes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        UNSPECIFIED,
        CLIENT_REQUEST,
        STEP_INTO,
        STEP_OVER,
        STEP_RETURN,
        STEP_RUNTO,
        STEP_END,
        BREAKPOINT,
        ENGINE_ERROR;

    }
}

